unit Main;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ComCtrls, LibXmlParser, ImgList;

type
  TForm1 = class(TForm)
    TreeView: TTreeView;
    Button1: TButton;
    ImageList: TImageList;
    procedure Button1Click(Sender: TObject);
  private
    { Private-Deklarationen }
  public
    { Public-Deklarationen }
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

procedure TForm1.Button1Click(Sender: TObject);
var
  XP            : TXmlParser;
  FrankfurtNode : TTreeNode;
  i             : integer;
begin
  XP := TXmlParser.Create;
  XP.LoadFromFile ('C:\Cd-Collection.xml');
  XP.StartScan;
  FrankfurtNode := nil;
  while XP.Scan do
    case XP.CurPartType of
      ptStartTag : begin
                     FrankfurtNode := TreeView.Items.AddChild (FrankfurtNode, XP.CurName);
                     FrankfurtNode.ImageIndex := 0;
                     for i := 0 to XP.CurAttr.Count-1 do
                       TreeView.Items.AddChild (FrankfurtNode, '  ' + XP.CurAttr.Name(i) + ' = ' + XP.CurAttr.Value(i));
                   end;
      ptContent  : TreeView.Items.AddChild (FrankfurtNode, 'Inhalt: ' + XP.CurContent);
      ptEndTag   : FrankfurtNode := FrankfurtNode.Parent;
      end;
  XP.Free;
end;

end.
